(
	global DCGammaTool
	try (destroydialog DCGammaTool) catch ()
	
	global DCGammaToolLastPathPicked
	if DCGammaToolLastPathPicked == undefined then DCGammaToolLastPathPicked = ""
	
	rollout DCGammaTool "DC Gamma Tool - v1.00" width:400
	(
		local linkColor = (color 200 200 255)
		local iniFile = GetDir #plugcfg + "\\dcGammaTool_settings.ini"
		local iniFileSec = "Settings"
		
		label lab_ChooseGamma "Choose your Gamma settings:" align:#left offset:[0,5]
		hyperLink hlk_info "info" pos:(lab_ChooseGamma.pos + [350,0]) address:"https://www.designconnected.com/gammatool" color:linkColor hovercolor:linkColor visitedcolor:linkColor
		radiobuttons rdb_DisabledGamma labels:#("Gamma - disabled (OFF)") default:1 align:#left offset:[0,5]
		radiobuttons rdb_MaxGamma labels:#("3ds Max Gamma - enabled (ON)") default:0 align:#left offset:[0,5]
		radiobuttons rdb_VrayGamma labels:#("V-Ray Gamma - enabled (ON)") default:0 align:#left offset:[0,5]
		spinner spn_GammaValue "Gamma value" range:[0,100,2.2] fieldwidth:45 align:#left offset:[18,5] enabled:false
		groupBox grp1 "" width:370 height:7 
		multilistBox lbx_Files "Files to convert:" width:370 height:15 offset:[0,5]
		checkbutton btn_AddFiles "Add files..." width:120 height:20 align:#left offset:[0,-2] across:3
		checkbutton btn_AddFolder "Add folder..." width:120 height:20 align:#left offset:[0,-2]
		checkbutton btn_Remove "Remove selected" width:120 height:20 align:#left offset:[0,-2]
		label lbl_SaveIn "Save new files in:" align:#left offset:[0,5]
		editText edt_SaveIn "" width:330 align:#left offset:[-3,0]
		checkbutton btn_SaveIn "..." pos:(edt_SaveIn.pos + [328,0]) width:40 height:18 
		checkbox chb_Suffix "Add suffix:" align:#left checked:true offset:[0,5]
		editText edt_Suffix "" width:100 pos:(chb_Suffix.pos + [75,-1])
		groupBox grp2 "" width:370 height:7 
		button btn_Close "Close" width:100 height:28 across:2 offset:[-25,10]
		checkbutton btn_Convert "Convert" width:200 height:28 offset:[-25,10]
		label lab_Offset "" offset:[-100,-5]
		
		local lastSize = [0,0]
		local gammaType = 1
		local filesList = #()
		local convertColorProps = #()
		local convertTextureProps = #()
		local convertedObjects = #()
		local convertedTextureName = "DC Gamma Correction Map"
		
		fn setViz =
		(
			local newSize = [DCGammaTool.width, DCGammaTool.height]
			if newSize != lastSize then
			(
				if newSize.x < 400 then newSize.x = DCGammaTool.width = 400
				if newSize.y < 500 then newSize.y = DCGammaTool.height = 500
				
				local uiMoveControls = #(btn_AddFiles, btn_AddFolder, btn_Remove, lbl_SaveIn, edt_SaveIn, btn_SaveIn, chb_Suffix, edt_Suffix, grp2, btn_Close, btn_Convert)
				local uiStrechControls = #(grp1, lbx_Files, grp2)
				local movePos = newSize.y - lastSize.y
				hlk_info.pos = lab_ChooseGamma.pos + [newSize.x - 50, 0]
				for u in uiMoveControls do u.pos.y += movePos
				lbx_Files.height += movePos
				for u in uiStrechControls do u.width = newSize.x - 30
				lastSize = newSize
				edt_SaveIn.width = newSize.x - 72
				btn_SaveIn.pos.x = edt_SaveIn.pos.x + newSize.x - 72
			)
			
			rdb_DisabledGamma.state = if gammaType == 1 then 1 else 0
			rdb_MaxGamma.state = if gammaType == 2 then 1 else 0
			rdb_VrayGamma.state = if gammaType == 3 then 1 else 0
			spn_GammaValue.enabled = gammaType > 1
			edt_Suffix.enabled = chb_Suffix.checked
		)
		
		
		fn getIniVal n default sec:undefined =
		(
			local s = if sec == undefined then iniFileSec else sec
			local val = getIniSetting iniFile s n
			if val.count != 0 then (if classof default == string then val else (try(execute val) catch(default))) else default 
		)
		
		fn setIniVal n val sec:undefined =
		(
			local s = if sec == undefined then iniFileSec else sec
			setIniSetting iniFile s n (val as string)
			OK
		)

		fn uniqueFileName n =
		(
			local uniq = copy n
			if doesfileexist n then
			(
				local ext = getFilenameType n
				local base = substring n 1 (n.count - ext.count)
				local i = 1
				while (doesfileexist (base + "(" + (i as string) + ")" + ext)) do i += 1
				uniq = base + "(" + (i as string) + ")" + ext
			)
			uniq
		)
		
		fn optFileName n =
		(
			local fixName = copy n
			local forbidden = "*.\"/\\[]:;|=,<>?%"
			for i = 1 to n.count do if findstring forbidden n[i] != undefined then fixName[i] = "_"
			fixName
		)
		
		fn isHdriObject obj =
		(
			local n = ""
			(((isProperty obj #HDRIMapName)and(n = obj.HDRIMapName; n.count > 0))or((isProperty obj #filename)and(n = obj.filename; n.count > 0)))and \
			((matchPattern n pattern:"*.hdr" ignoreCase:true)or(matchPattern n pattern:"*.hdri" ignoreCase:true))
		)
		
		fn SetPropertyPlus obj pName pVal =
		(
			-- check for array values
			local nm = pName as string
			if (matchPattern nm pattern:"texmap_blend_?" ignoreCase:true)and(findstring "012345678" nm[nm.count] != undefined) then obj.texmap_blend[(execute nm[nm.count]) + 1] = pVal 
			else SetProperty obj pName pVal
			OK
		)
		
		fn removeDCGammaCorrectionMap obj =
		(
			local propsArr = try (GetPropNames obj) catch (undefined)
			if propsArr != undefined then for pName in propsArr do 
			(
				local pVal = try(GetProperty obj pName)catch(#error)
				if (classof pVal == Color_Correction)and(pVal.name == convertedTextureName) then (pVal = pVal.map; SetPropertyPlus obj pName pVal)
				if (superclassof pVal == textureMap) then removeDCGammaCorrectionMap pVal
			)
			obj
		)

		fn convertColorGamma c g =
		(
			local new = copy c
			new.r = 255.0*((new.r/255)^g)
			new.g = 255.0*((new.g/255)^g)
			new.b = 255.0*((new.b/255)^g)
			new
		)
		
		fn convertTextureGamma t g rem:true =
		(	
			if rem then removeDCGammaCorrectionMap t
			if (isHdriObject t) then t
			else
			(
				local new = if (classof t == Color_Correction)and(t.name == convertedTextureName) then t else Color_Correction name:convertedTextureName map:t
				new.lightnessMode = 1
				new.gammaRGB = g
				new
			)
		)
		
		fn convertSubsBitmaptextureGamma t g =
		(
			local obj = removeDCGammaCorrectionMap t
			local propsArr = try (GetPropNames obj) catch (undefined)
			if propsArr != undefined then for pName in propsArr do 
			(
				local pVal = try(GetProperty obj pName)catch(#error)
				if (classof pVal == Bitmaptexture) then SetPropertyPlus obj pName (convertTextureGamma pVal g rem:false)
				else if superclassof pVal == textureMap then convertSubsBitmaptextureGamma pVal g
			)
			obj
		)
		
		fn setPropertyMap m pName new =
		(
			SetPropertyPlus m pName new
			if (superclassof m == material)and(pName == #texmap_diffuse) then 
			(
				allTxt = getClassInstances bitmaptexture target:new
				if allTxt.count > 0 then showTextureMap m allTxt[1] on
									else showTextureMap m on
			)
			OK
		)
		
		fn convertFalloffGamma m pName fromGammaValue gammaValue type ppName pVal =
		(
			-- remove any old max gama values
			local gValue = undefined
			local pos = findstring pVal.name "_dcg"
			if (pos != undefined)and(pos > 0) then 
			(
				local valTxt = substring pVal.name (pos+4) -1
				local val = try (execute valTxt) catch (undefined)
				if classof val == float then gValue = val
			)
			if gValue != undefined then
			(
				pVal.name = substring pVal.name 1 (pos-1)
				pVal.color1 = convertColorGamma pVal.color1 (1.0/gValue)
				pVal.color2 = convertColorGamma pVal.color2 (1.0/gValue)
				if classof pVal.map1 == falloff then convertFalloffGamma pVal #map1 gValue 1.0 0 ppName pVal.map1
				if classof pVal.map2 == falloff then convertFalloffGamma pVal #map2 gValue 1.0 0 ppName pVal.map2
			)
			else
			(
				if (pVal.map1 != undefined)and(pVal.map1.name == convertedTextureName) then pVal.map1 = pVal.map1.map
				if (pVal.map2 != undefined)and(pVal.map2.name == convertedTextureName) then pVal.map2 = pVal.map2.map
			)
			-- set max gamma value
			if type == 2 then
			(
				if (finditem convertTextureProps ppName > 0) then
				(
					if (pVal.map1 == undefined)and(pVal.map2 == undefined) then setPropertyMap m pName (convertTextureGamma pVal (1.0/gammaValue))
					else if finditem convertedObjects pVal == 0 then
					(
						append convertedObjects pVal
						pVal.name += "_dcg" + (gammaValue as string)
						pVal.color1 = convertColorGamma pVal.color1 (1.0*gammaValue)
						pVal.color2 = convertColorGamma pVal.color2 (1.0*gammaValue)
						if classof pVal.map1 == falloff then convertFalloffGamma pVal #map1 fromGammaValue gammaValue type ppName pVal.map1
						if classof pVal.map2 == falloff then convertFalloffGamma pVal #map2 fromGammaValue gammaValue type ppName pVal.map2
					)
				)
				else
				(
					if classof pVal.map1 == falloff then convertFalloffGamma pVal #map1 fromGammaValue gammaValue type ppName pVal.map1
					else if pVal.map1 != undefined then setPropertyMap pVal #map1 (convertTextureGamma pVal.map1 (1.0*gammaValue))
					if classof pVal.map2 == falloff then convertFalloffGamma pVal #map2 fromGammaValue gammaValue type ppName pVal.map2
					else if pVal.map2 != undefined then setPropertyMap pVal #map2 (convertTextureGamma pVal.map2 (1.0*gammaValue))
				)
			)
			OK
		)

		fn gammaAdjustProperty m pName fromGammaValue gammaValue type = 
		(
			local pVal = try(GetProperty m pName)catch(#error)
			case type of
			(
				1:(
					-- reset
					if (classof pVal == falloff) then convertFalloffGamma m pName fromGammaValue gammaValue type pName pVal
					else if (superclassof pVal == textureMap) then pVal = removeDCGammaCorrectionMap pVal
					
					if (classof pVal == Color_Correction)and(pVal.name == convertedTextureName) then setPropertyMap m pName pVal.map
					else if (classof pVal == color)and(finditem convertColorProps pName > 0) then SetPropertyPlus m pName (convertColorGamma pVal (1.0*gammaValue/fromGammaValue))
				)
				
				2:(
					-- remove CorrectionMap
					if (classof pVal == Color_Correction) then (setPropertyMap m pName pVal.map; pVal = pVal.map)
					-- convert others
					if (classof pVal == falloff) then convertFalloffGamma m pName fromGammaValue gammaValue type pName pVal
					else if (superclassof pVal == textureMap) then 
					(
						pVal = removeDCGammaCorrectionMap pVal
						if finditem convertTextureProps pName > 0 then 
						(
							if classof pVal != Bitmaptexture then setPropertyMap m pName (convertTextureGamma (convertSubsBitmaptextureGamma pVal (1.0*gammaValue)) (1.0/gammaValue) rem:false)
						)
						else
						(
							if classof pVal != Bitmaptexture then setPropertyMap m pName (convertSubsBitmaptextureGamma pVal (1.0*gammaValue))
															 else setPropertyMap m pName (convertTextureGamma pVal (1.0*gammaValue))
						)
					)
					else if (classof pVal == color)and(finditem convertColorProps pName > 0)and(gammaValue != fromGammaValue) then SetPropertyPlus m pName (convertColorGamma pVal (1.0*gammaValue/fromGammaValue))
				)
				
				3:(
					-- reset falloff
					if (classof pVal == falloff) then convertFalloffGamma m pName fromGammaValue gammaValue type pName pVal
					else if (superclassof pVal == textureMap) then pVal = removeDCGammaCorrectionMap pVal
				
					-- convert others
					if (superclassof pVal == textureMap)and(finditem convertTextureProps pName > 0) then setPropertyMap m pName (convertTextureGamma pVal (1.0/gammaValue))
					else if (classof pVal == Color_Correction)and(pVal.name == convertedTextureName) then setPropertyMap m pName (removeDCGammaCorrectionMap pVal.map)
					else if (classof pVal == color)and(finditem convertColorProps pName > 0)and(gammaValue != fromGammaValue) then SetPropertyPlus m pName (convertColorGamma pVal (1.0*gammaValue/fromGammaValue))
				)
			)
			OK
		)
		
		fn gammaAdjustObject m gammaValue type = 
		(
			if (m != undefined)and(finditem convertedObjects m == 0) then
			(
				append convertedObjects m
				local fromGammaValue = undefined
				local mName = "" + m.name 
				local pos = findstring mName "_dcg"
				if (pos != undefined)and(pos > 0) then 
				(
					local val = try (execute (substring mName (pos+4) -1)) catch (undefined)
					if classof val == float then fromGammaValue = val
					mName = substring mName 1 (pos-1)
				)
			
				if (fromGammaValue != gammaValue)or(type != 1) then
				(
					if fromGammaValue == undefined then fromGammaValue = 1.0
					-- convert properties
					local propsArr = try (GetPropNames m) catch (undefined)
					if propsArr != undefined then for pName in propsArr do gammaAdjustProperty m pName fromGammaValue gammaValue type
					-- convert sub-materials
					if superclassof m == material then for i = 1 to getNumSubMtls m do gammaAdjustObject (getSubMtl m i) gammaValue type 
				)
				
				-- set new name
				m.name = mName + "_dcg" + (gammaValue as string)
				
			)
			OK
		)

		fn gammaAdjustMaterials materialsToAdjust gammaValue type = 
		(
			convertedObjects = #()
			convertColorProps = #(#diffuse, #refraction_fogColor, #refraction_exitColor, #translucency_color, #color)
			convertTextureProps = #(#texmap_diffuse, #texmap_refraction_fog, #texmap)
			for m in materialsToAdjust do gammaAdjustObject m (if type == 1 then 1.0 else gammaValue) type
			convertedObjects = #()
			OK
		)

		fn gammaAdjustLights lightsToAdjust gammaValue type =
		(
			convertedObjects = #()
			convertColorProps = #(#color)
			convertTextureProps = #(#texmap)
			for l in lightsToAdjust do gammaAdjustObject l (if type == 1 then 1.0 else gammaValue) type
			convertedObjects = #()
			OK
		)
		
		fn gammaAdjustGeometry objectsToAdjust gammaValue type =
		(
			local objModifiers = #()
			for obj in objectsToAdjust do for m in obj.modifiers do if finditem objModifiers m == 0 then append objModifiers m
				
			convertedObjects = #()
			convertColorProps = #(#color)
			convertTextureProps = #()
			for obj in objectsToAdjust + objModifiers do gammaAdjustObject obj (if type == 1 then 1.0 else gammaValue) type
			convertedObjects = #()
			
			OK
		)
		
		
		
		on rdb_DisabledGamma changed state do (gammaType = 1; setViz())
		on rdb_MaxGamma changed state do (gammaType = 2; setViz())
		on rdb_VrayGamma changed state do (gammaType = 3; setViz())
		on chb_Suffix changed state do (setViz())
		
		on btn_AddFiles changed state do 
		(
			if state then
			(
				if classof dotnet == StructDef then 
				(
					local getFilesDialog = dotNetObject "System.Windows.Forms.OpenFileDialog"
					getFilesDialog.title = "Select Files"
					getFilesDialog.Multiselect = true
					getFilesDialog.Filter = "3ds Max Files(*.max)|*.max"
					getFilesDialog.FilterIndex = 1
					getFilesDialog.InitialDirectory = "" + DCGammaToolLastPathPicked
					local result = getFilesDialog.showDialog()
					if result.Equals result.OK then
					(
						result.ToString()
						for f in getFilesDialog.fileNames do
						(
							if finditem filesList f == 0 then append filesList f
							DCGammaToolLastPathPicked = getFilenamePath f
						)
						lbx_Files.items = filesList
					)
				)
				else 
				(
					local f = getOpenFileName caption:"Select File" types:"3ds Max Files(*.max)|*.max|"
					if f != undefined then 
					(
						if finditem filesList f == 0 then append filesList f
						DCGammaToolLastPathPicked = getFilenamePath f
						lbx_Files.items = filesList
					)
				)
				
			)
			btn_AddFiles.checked = false
		)
		on btn_AddFolder changed state do 
		(
			if state then
			(
				local target = getSavePath caption:"Select Folder" initialDir:DCGammaToolLastPathPicked
				if target != undefined then
				(
					if target[target.count] != "\\" then target += "\\"
					for f in getFiles (target + "*.max") do if finditem filesList f == 0 then append filesList f
					lbx_Files.items = filesList
					DCGammaToolLastPathPicked = target
				)
			)
			btn_AddFolder.checked = false
		)
		on btn_Remove changed state do 
		(
			if state then
			(
				filesList = for f in -lbx_Files.selection collect filesList[f]
				lbx_Files.selection = #{}
				lbx_Files.items = filesList
			)
			btn_Remove.checked = false
		)
		on btn_SaveIn changed state do 
		(
			if state then
			(
				local target = getSavePath caption:"Select Folder" initialDir:(if edt_SaveIn.text == "" then DCGammaToolLastPathPicked else edt_SaveIn.text)
				if target != undefined then
				(
					if target[target.count] != "\\" then target += "\\"
					edt_SaveIn.text = target
				)
			)
			btn_SaveIn.checked = false
		)
		
		
		on btn_Convert changed state do 
		(
			if state then
			(
				local errorsList = ""
				local filesDone = #()
				
				if filesList.count == 0 then errorsList += "Select 3ds Max files to convert!\n"
				else if doesfileexist edt_SaveIn.text == false then errorsList += "Select existing location for the new files!\n"
				else
				(
					try(setVRaySilentMode()) catch()
					for f in filesList do
					(
						if loadMaxFile f useFileUnits:true quiet:true then 
						(
							-- convert
							local saveFile = true
							local materialsList = for m in scenematerials collect m
							for m in meditMaterials do if (finditem materialsList m == 0)and(classof m == Multimaterial) then append materialsList m
							--try 
							(
								gammaAdjustMaterials materialsList spn_GammaValue.value gammaType
								gammaAdjustLights (lights as array) spn_GammaValue.value gammaType
								gammaAdjustGeometry (geometry as array) spn_GammaValue.value gammaType
							) 
						/*	catch 
							(
								errorsList += "Error converting file: " + (filenameFromPath f) + "\n"
								saveFile = false
							)*/
							
							if saveFile then 
							(
								-- set files gamma settings
								try (IDisplayGamma.affectMEdit = true) catch ()
								try (IDisplayGamma.affectColorPickers = true) catch ()
								case gammaType of
								(
									1: (
										IDisplayGamma.colorCorrectionMode = #none
										IDisplayGamma.gamma = 2.2
										fileInGamma = 2.2
										fileOutGamma = 2.2
										try 
										(
											renderers.current.colorMapping_gamma = 1.0
											renderers.current.colorMapping_adaptationOnly = 2
										) 
										catch ()
									)
									2: (
										IDisplayGamma.colorCorrectionMode = #gamma
										IDisplayGamma.gamma = spn_GammaValue.value
										fileInGamma = spn_GammaValue.value
										fileOutGamma = spn_GammaValue.value
										try 
										(
											renderers.current.colorMapping_gamma = 1.0
											renderers.current.colorMapping_adaptationOnly = 2
										) 
										catch ()
									)
									3: (
										IDisplayGamma.colorCorrectionMode = #none
										IDisplayGamma.gamma = 1.0
										fileInGamma = 1.0
										fileOutGamma = 1.0
										try 
										(
											renderers.current.colorMapping_gamma = spn_GammaValue.value
											renderers.current.colorMapping_adaptationOnly = 0
										) 
										catch ()
									)
								)
								-- save new file
								local newFile = "" + edt_SaveIn.text
								if newFile[newFile.count] != "\\" then newFile += "\\"
								newFile += (getFilenameFile f) + (if chb_Suffix.checked then optFileName edt_Suffix.text else "") + ".max"
								newFile = uniqueFileName newFile
								--format "New file: % (% - gamma)\n" newFile (if gammaType == 1 then 1.0 else spn_GammaValue.value)
								
								if saveMaxFile newFile useNewFile:false quiet:true then append filesDone f
								else errorsList += "Error saving 3ds Max file: " + (filenameFromPath newFile) + "\n"
							)
						)
						else errorsList += "Error opening 3ds Max file: " + (filenameFromPath f) + "\n"
					)
					resetMaxFile #noPrompt 
				)
				filesList = for f in filesList where finditem filesDone f == 0 collect f
				lbx_Files.items = filesList
				if errorsList.count > 0 then messagebox errorsList title:"Gamma Convert Errors:" 
			)
			btn_Convert.checked = false
		)
		
		
		on btn_Close pressed do
		(
			try (destroydialog DCGammaTool) 
			catch()
		)
		
		on DCGammaTool resized val do
		(
			setViz()
		)
		
		on DCGammaTool open do
		(
			-- load saved values
			gammaType = getIniVal "GammaType" gammaType
			spn_GammaValue.value = getIniVal "GammaValue" spn_GammaValue.value
			edt_SaveIn.text = getIniVal "SaveIn" edt_SaveIn.text
			chb_Suffix.checked = getIniVal "AddSuffix" chb_Suffix.checked
			edt_Suffix.text = getIniVal "AddSuffixText" edt_Suffix.text
			
			lastSize = [DCGammaTool.width, DCGammaTool.height] 
			setViz()
		)
		
		on DCGammaTool close do
		(
			-- save last values
			setIniVal "GammaType" gammaType
			setIniVal "GammaValue" spn_GammaValue.value
			setIniVal "SaveIn" edt_SaveIn.text
			setIniVal "AddSuffix" chb_Suffix.checked
			setIniVal "AddSuffixText" edt_Suffix.text
		)
	)
	
	createdialog DCGammaTool style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing)
  
)

/*
DCGammaTool.gammaAdjustMaterials #($.material) 2.2 1
DCGammaTool.gammaAdjustMaterials #($.material) 2.2 2
DCGammaTool.gammaAdjustMaterials #($.material) 2.2 3

DCGammaTool.gammaAdjustGeometry #($) 2.2 1
DCGammaTool.gammaAdjustGeometry #($) 2.2 2
DCGammaTool.gammaAdjustGeometry #($) 2.2 3

DCGammaTool.gammaAdjustLights (lights as array) 2.2 1
DCGammaTool.gammaAdjustLights (lights as array) 2.2 2
DCGammaTool.gammaAdjustLights (lights as array) 2.2 3
*/